<?php
/**
* @version		$Id: default.php 00006 2010-10-30 00:00:00 umitkenan $
* @package		Joomla
* @subpackage	JT SlideShow Module
* @author		mit Kenan Gnll
* @link 		http://www.jt.gen.tr
* @copyright	Copyright (C) Joomla Trke Eitim ve Destek Sitesi. http://www.jt.gen.tr 
* @license		GNU/GPL
*/

// no direct access
defined('_JEXEC') or die;

class modJTSlideShowHelper
{
	static function getList(&$params)
    {
		// jQuery Cycle Plugin Parameters
		$list->fx						= $params->get ( 'fx', 'fade' );
		$list->timeout					= trim ( $params->get ( 'timeout', 4000 ) );
		$list->timeoutFn				= 'null';
		$list->continuous				= trim ( $params->get ( 'continuous', 0 ) );
		$list->speed					= trim ( $params->get ( 'speed', 1000 ) );
		$list->speedIn					= trim ( $params->get ( 'speedIn', 'null' ) );
		if ( $list->speedIn == '' ) $list->speedIn = 'null';
		
		$list->speedOut					= trim ( $params->get ( 'speedOut', 'null' ) );
		if ( $list->speedOut == '' ) $list->speedOut = 'null';

		$list->prevNextClick			= 'null';
		$list->pagerClick				= 'null';
		$list->pagerEvent				= trim ( $params->get ( 'pagerEvent', 'click' ) );
		$list->pagerAnchorBuilder		= 'null';
		$list->before					= 'null';
		$list->after					= 'null';
		$list->end						= 'null';
		$list->easing					= trim ( $params->get ( 'easing', 'null' ) );
		if ($list->easing != 'null') $list->easing = "'". $list->easing ."'";
		$list->easeIn					= trim ( $params->get ( 'easeIn', 'null' ) );
		if ($list->easeIn != 'null') $list->easeIn = "'". $list->easeIn ."'";
		$list->easeOut					= trim ( $params->get ( 'easeOut', 'null' ) );
		if ($list->easeOut != 'null') $list->easeOut = "'". $list->easeOut ."'";

		$list->shufflesetting			= trim ( $params->get ( 'shufflesetting', 'null' ) );
		if ( $list->shufflesetting == '' ) $list->shufflesetting = 'null';
		if ( $list->shufflesetting != 'null' ) $list->shufflesetting = '{ '.$list->shufflesetting.' }';	

		$list->animIn					= 'null';
		$list->animOut					= 'null';
		$list->cssBefore				= 'null';
		$list->cssAfter					= 'null';
		$list->fxFn						= 'null';
		$list->height					= 'auto';
		$list->startingSlide			= 0;
		$list->sync						= 1;
		$list->random					= trim ( $params->get ( 'random', 0 ) );
		$list->fit						= trim ( $params->get ( 'fit', 0 ) );
		$list->containerResize			= trim ( $params->get ( 'containerResize', 1 ) );
		$list->pause					= trim ( $params->get ( 'pause', 1 ) );
		$list->pauseOnPagerHover		= trim ( $params->get ( 'pauseOnPagerHover', 0 ) );
		$list->autostop					= trim ( $params->get ( 'autostop', 0 ) );
		$list->autostopCount			= 0;
		$list->delay					= trim ( $params->get ( 'delay', 0 ) );
		if ( $list->delay == '' ) $list->delay = 0;

		$list->slideExpr				= 'null';
		$list->nowrap					= trim ( $params->get ( 'nowrap', 0 ) );
		$list->fastOnEvent				= 0;
		$list->randomizeEffects			= trim ( $params->get ( 'randomizeEffects', 1 ) );
		$list->rev						= trim ( $params->get ( 'rev', 0 ) );
		$list->manualTrump				= 'true';
		$list->requeueOnImageNotLoaded	= 'true';
		$list->requeueTimeout			= '250';
		
		// Loading images, urls, titles, styles, options, etc..
		$list->image 					= explode ( "\n", trim ( $params->get ( 'images' ) ) );
		if ( $params->get( 'linked', 1 ) == 1 )
			$list->url 					= explode ( "\n", trim ( $params->get ( 'urls' ) ) );
		$list->title 					= htmlspecialchars ( trim ( $params->get ( 'captions' ) ) );
		$list->title 					= explode ( "\n", $list->title );
		$list->folder					= trim ( $params->get ( 'folder' ) );
		$list->showallimages			= $params->get( 'showallimages', 0 );
		$list->target					= trim ( $params->get ( 'target', '_blank' ) );
		if ( $list->target == "iFrame" ) {
			$list->iframewidth			= trim ( $params->get ( 'iframewidth', '600' ) );
			$list->iframeheight			= trim ( $params->get ( 'iframeheight', '400' ) ); }
		$list->linked					= $params->get( 'linked', 1 );
		$list->showcaption				= $params->get( 'showcaption', 0 );
		if ( $list->showcaption == 1 ) {
			$list->captionposition		= $params->get( 'captionposition', 'bottom' );
			$list->captionalign			= $params->get( 'captionalign', 'center' ); }

		// If adding "http" is YES
		if ( $list->linked == 1 ) {
			if (trim ( $params->get ( 'addhttp' ) )) {
				for ( $i=0 ; $i < count($list->image) ; $i++ )
					$list->url[$i]="http://".$list->url[$i]; } }

		$list->imgwidth					= trim ( $params->get ( 'imgwidth', '170px' ) );
		$list->imgheight				= trim ( $params->get ( 'imgheight', '128px' ) );
		$list->imgborder				= trim ( $params->get ( 'imgborder', 0 ) );
		$list->imgbordersize			= trim ( $params->get ( 'imgbordersize', '5px' ) );
		$list->imgbordercolor			= trim ( $params->get ( 'imgbordercolor', '#eee' ) );

		if(strpos($list->imgwidth,'px') === false && strpos($list->imgwidth,'%') === false) $list->imgwidth = 0;
		if(strpos($list->imgheight,'px') === false && strpos($list->imgheight,'%') === false) $list->imgheight = 0;

		if ($list->imgborder == 1) {
			if(strpos($list->imgwidth,'px')) $list->imgwidth = ((str_replace('px','',$list->imgwidth)) - ($list->imgbordersize * 2) ).'px';
			if(strpos($list->imgheight,'px')) $list->imgheight = ((str_replace('px','',$list->imgheight)) - ($list->imgbordersize * 2) ).'px';
			if(strpos($list->imgwidth,'%')) $list->imgwidth = ((str_replace('%','',$list->imgwidth)) - ($list->imgbordersize / 2)).'%';
			if(strpos($list->imgheight,'%')) $list->imgheight = ((str_replace('%','',$list->imgheight)) - ($list->imgbordersize / 2)).'%';
		}

		// Navigation Bar, Previous - Next navigation buttons, and Box name
		$list->navigationbar			= trim ( $params->get ( 'navigationbar', 0 ) );
		if ($list->navigationbar == 1)
			$list->navigationbarloop	= trim ( $params->get ( 'navigationbarloop', 0 ) );

		$list->boxname 					= trim ( $params->get ( 'boxname', 'slideshowbox' ) );

		$list->next						= $list->boxname. "next";
		$list->prev						= $list->boxname. "prev";
		
		// If show caption is ON
		if ( $list->showcaption == 1 ) {
			$list->before = "function(idx, slide) { var caption = jQuery('img',slide).attr('alt'); jQuery('#". $list->boxname ."Caption').html(' ' + caption + ' '); }";
			$list->after = "function(idx, slide) { var caption = jQuery('img',slide).attr('alt'); jQuery('#". $list->boxname ."Caption').html(' ' + caption + ' '); }"; }	
		
		// If navigation bar is ON. Hide (prev button for first image) or show (next button for last image) navigation buttons
		if ( $list->navigationbar == 1 && $list->navigationbarloop == 1 )
			$list->after = "function(curr, next, opts) { var index = opts.currSlide; jQuery('#". $list->prev ."')[index == 0 ? 'hide' : 'show'](); jQuery('#". $list->next ."')[index == opts.slideCount - 1 ? 'hide' : 'show'](); }";		

		// Pagination params
		$list->pagination				= trim ( $params->get ( 'pagination', 0 ) );
		if ( $list->pagination == 1 ) {
			$list->paginationbarposition	= trim ( $params->get ( 'paginationbarposition', 'top' ) );
			$list->paginationbarborder		= trim ( $params->get ( 'paginationbarborder', 0 ) );
			$list->paginationbarbordercolor	= trim ( $params->get ( 'paginationbarbordercolor', '#eee' ) );
			$list->paginationitemsborder	= trim ( $params->get ( 'paginationitemsborder', 1 ) );
			$list->paginationbaralign		= trim ( $params->get ( 'paginationbaralign', 'center' ) ); 

			if ( $list->paginationbaralign == "caption" ) $list->paginationbaralign = $list->captionalign; }

		// Gallery params
		$list->gallery					= trim ( $params->get ( 'gallery', 0 ) );

		// Gallery thumbnail dimensions are required for Cycle Plugin
		$list->gallerythumbnailwidth	= '';
		$list->gallerythumbnailheight	= '';

		if ( $list->gallery == 1 ) {
			$list->galleryposition			= trim ( $params->get ( 'galleryposition', 'top' ) );

			if ( $list->galleryposition  == 'top' ) $params->set ( 'gallerywidth', 'auto' );

			$list->gallerywidth				= trim ( $params->get ( 'gallerywidth', 'auto' ) );
		
			if ( $list->galleryposition  == 'left' || $list->galleryposition  == 'right')
				if(strpos($list->gallerywidth,'px') === false && strpos($list->gallerywidth,'%') === false) $list->gallerywidth = 'auto';
		
			$list->gallerydirection			= trim ( $params->get ( 'gallerydirection', 'left' ) );

			$list->gallerythumbnailboxwidth	= trim ( $params->get ( 'gallerythumbnailboxwidth', '90px' ) );
			$list->gallerythumbnailboxheight= trim ( $params->get ( 'gallerythumbnailboxheight', '90px' ) );
		
			$list->galleryfitthumbnail		= trim ( $params->get ( 'galleryfitthumbnail', 0 ) );

			$list->gallerythumbnailwidth	= trim ( $params->get ( 'gallerythumbnailwidth', '180px' ) );
			$list->gallerythumbnailheight	= trim ( $params->get ( 'gallerythumbnailheight', '100%' ) );
		
			if ($list->galleryfitthumbnail == 1) {
				$list->gallerythumbnailwidth = $list->gallerythumbnailboxwidth;
				$list->gallerythumbnailheight= $list->gallerythumbnailboxheight; }
		
			$list->gallerythumbnailspace	= trim ( $params->get ( 'gallerythumbnailspace', '5px' ) );

			if(strpos($list->gallerythumbnailspace,'px') === false && strpos($list->gallerythumbnailspace,'%') === false) $list->gallerythumbnailspace = 0;

			$list->gallerythumbnailborder		= trim ( $params->get ( 'gallerythumbnailborder', 1 ) );
			$list->gallerythumbnailbordercolor	= trim ( $params->get ( 'gallerythumbnailbordercolor', '#ccc' ) );
			$list->gallerythumbnailbordersize	= trim ( $params->get ( 'gallerythumbnailbordersize', '3px' ) );

			if(strpos($list->gallerythumbnailbordersize,'px') === false && strpos($list->gallerythumbnailbordersize,'%') === false) $list->gallerythumbnailbordersize = 0; }

		// Caption
		if ( $list->showcaption == 1 ) $list->caption = '<div id="'. $list->boxname .'Caption" style="text-align: '. $list->captionalign .'"></div>';

		// Navigation Bar Content
		if ( $list->navigationbar == 1 ) {
			$list->navigationbarcontent = '<div id="'. $list->boxname . 'navigationbar" style="text-align:center;">'  
				. '<a style="float:left;" id="'.$list->prev.'" href="javascript:void(0);"><img src="'.JURI::root().'/modules/mod_jt_slideshow/images/prev.gif" border="0" /></a>'
				. '<a style="float:right;" id="'.$list->next.'" href="javascript:void(0);"><img src="'.JURI::root().'/modules/mod_jt_slideshow/images/next.gif" border="0" /></a>'
				. '</div>'; }
		
		// Pagination Bar Content
		if ( $list->pagination == 1 && $list->gallery == 0 ) {
			$list->paginationbarcontent = '<div id="'.$list->boxname.'nav" style="text-align: '. $list->paginationbaralign .'"></div><div style="clear:both"></div>'; }
		
		// Gallery params and layer
		$list->showgallery = 0;
		$list->slideshowboxposition = '';
		$list->gallerycontent = '';
		
		if ( $list->pagination == 0 && $list->gallery == 1 ) {
			$list->showgallery = 1;

			if ( $list->galleryposition  == 'left') $list->slideshowboxposition = 'float: right;';
			if ( $list->galleryposition  == 'right') $list->slideshowboxposition = 'float: left;';
			
			$list->gallerycontent = '<div id="'.$list->boxname.'gallery"></div>';
			
			if ( $list->galleryposition  == 'top' ) $list->gallerycontent = $list->gallerycontent . '<div class="JT-ClearBox"></div>';

			if ( $list->galleryposition  == 'top' ) $list->galleryposition = '';
			if ( $list->galleryposition  == 'left' || $list->galleryposition  == 'right') $list->galleryposition = 'float: '.$list->galleryposition; }

		// Show all images
		if ($list->showallimages) {
			// Directory SlideShow
			// if subdirectory parameter is yes
			$jpgimages = glob("".$list->folder."/*.jpg");
			$pngimages = glob("".$list->folder."/*.png");
			$gifimages = glob("".$list->folder."/*.gif");

			// Generating image array
			// Adding jpeg files to (directory) slideshow
			$list->image = $jpgimages;

			// Adding png files to (directory) slideshow
			$j=0;
			for ($i = count($jpgimages); $i < count($jpgimages)+count($pngimages); $i++) {
				$list->image[$i]=$pngimages[$j];
				$j=$j+1; }
		
			// Adding gif files to (directory) slideshow
			$j=0;
			for ($i = count($list->image); $i < count($jpgimages)+count($pngimages)+count($gifimages); $i++) {
				$list->image[$i]=$gifimages[$j];
				$j=$j+1; } }

		// SqueezeBox
		if ($list->linked == 1 && $list->target == "iFrame")
				$list->SqueezeBoxiFrame = "{handler: 'iframe', size: {x: ".$list->iframewidth.", y: ".$list->iframeheight."}, iframePreload:true}";
		if ($list->linked == 2) 
			$list->SqueezeBox = ' rel="SqueezeBox" class="modal"';

		// SlideShow Content - Loop
		for ( $i=0 ; $i < count($list->image) ; $i++ ) {
			// Trimming image file names
			$list->image[$i] 			= trim($list->image[$i]);
			// Initializing Titles
			$list->alt[$i] 				= '';
			$list->alttitle[$i] 		= '';	
			// Initializing URL
			if ( $list->linked == 1 && $i >= count($list->url) )
				$list->url[$i] 			= '';	

			// Show Metatags (If number of titles are equal or smaller than number of images)
			if ( $i < count($list->title) ) {
				// Preparing Titles
				$list->alt[$i] 				= $list->title[$i] ? ' alt="'. trim($list->title[$i]) .'"' : '';
				$list->alttitle[$i] 		= $list->title[$i] ? ' title="'. trim($list->title[$i]) .'"' : ''; }
			
			if ( $list->linked == 1 )
				$list->url[$i] 				= $list->url[$i] ? trim($list->url[$i]) : '';

			// Preparing Links
			if ( $list->linked == 1 && $list->url[$i] != '' ) {
				if ( $list->target == "iFrame" )
					$list->imagelinkstart[$i] 	= '<a class="modal" rel="'.$list->SqueezeBoxiFrame .'" href="'. $list->url[$i] .'" />';
				else
					$list->imagelinkstart[$i] 	= '<a href="'. $list->url[$i] .'" target="'. $list->target .'">'; }
			else if ( $list->linked == 2 ) {
				if ( !$list->showallimages )
					$list->imagelinkstart[$i] 	= '<a href="'.JURI::root() . $list->folder . '/' . $list->image[$i].'" '. $list->alttitle[$i] . $list->SqueezeBox . ' >';
				else
					$list->imagelinkstart[$i] 	= '<a href="'.JURI::root() . $list->image[$i].'" '. $list->alttitle[$i] . $list->SqueezeBox . ' >'; }
			else 
				$list->imagelinkstart[$i] 	= '<a href="javascript:void(0);">';

			$list->imagelinkend		 	= '</a>';
			
			// Show Only Entered Images
			if (!$list->showallimages) {
				// External Image Resource
				if (strstr($list->image[$i],'<ext>')) {
					$list->image[$i] = str_replace('<ext>','',$list->image[$i]);
					$list->imagewithpath[$i] = '<div class="mask-slider"></div><img src="'. $list->image[$i] . '" '. $list->alt[$i] . $list->alttitle[$i] .'/>'; }
				// Internal Image Resource
				else $list->imagewithpath[$i] = '<div class="mask-slider"></div><img src="'.JURI::root() . $list->folder . '/' . $list->image[$i] . '" '. $list->alt[$i] . $list->alttitle[$i] .'/>'; }
			// Show All Images in the folder
			else $list->imagewithpath[$i] = '<div class="mask-slider"></div><img src="'.JURI::root() . $list->image[$i] . '" '. $list->alt[$i] . $list->alttitle[$i] .'/>';
			// Prepared SlideShow (Content) Image:
			$list->slideshowcontent[$i]	= $list->imagelinkstart[$i].$list->imagewithpath[$i].$list->imagelinkend; }

		// JT SlideShow Footer
		$list->jtslideshowfooter = '';
		if ( $params->get ( 'jtslideshowfooter' ) == null || $params->get ( 'jtslideshowfooter' ) == ''  ) $params->set ( 'jtslideshowfooter', 1 );
		if ( $params->get ( 'jtslideshowfooter' ) == 1 )
			$list->jtslideshowfooter = '<div id="'.$list->boxname.'footer">'.JText::_( 'MOD_JT_SLIDESHOW_FOOTER_MESSAGE').'</div><div class="JT-ClearBox"></div>';

		// Preparing CSS style
		// Clear Box
		$css = ' div.JT-ClearBox { display: block; height: 0; clear: both; visibility: hidden; } ';
		// JT SlideShow Footer
		if ( $params->get ( 'jtslideshowfooter' ) == 1 ) $css = $css . ' DIV#'.$list->boxname.'footer { display:none; padding-top: 10px; font-family: Tahoma,Verdana,sans-serif; font-size: 8px; font-weight: bold; } ';
		// SlideShow Box
		$css = $css . ' DIV#'.$list->boxname.' { display:none; margin: 0px auto; '.$list->slideshowboxposition.' } ';
		// SlideShow Box - Images
		$css = $css . ' DIV#'.$list->boxname.' img { width: '.$list->imgwidth.'; height: '.$list->imgheight.'; } ';
		if ($list->imgborder == 1) $css = $css . ' DIV#'.$list->boxname.' img { border-width: '. $list->imgbordersize .'; border-style: solid; border-color: '. $list->imgbordercolor .'; } ';
		// Caption
		if ( $list->showcaption == 1 ) $css = $css . ' DIV#'.$list->boxname.'Caption { font-weight: bold; font-size: 110%; line-height: 2em; } ';
		// Navigation Bar
		if ( $list->navigationbar == 1 ) {
			$css = $css . ' DIV#'.$list->boxname.'navigationbar { display:none; margin: '. (str_replace('px','',$list->imgheight)) / 2 .'px auto; position:absolute; top:0; right:0; width: 100%; z-index: 10; } ';
			$css = $css . ' DIV#'.$list->boxname.'navigationbar a { background-color: transparent; } '; }
		// Pagination Bar Group
		if ( $list->pagination == 1 && $list->gallery == 0 ) :
			// Pagination Bar - Line
			$css = $css . ' #'.$list->boxname.'nav { display:none; margin-top:5px; margin-bottom:5px; } ';
			if ($list->paginationbarborder == 1) $css = $css . ' #'.$list->boxname.'nav { background-color: '.$list->paginationbarbordercolor.'; } ';
			// Pagination Bar - Links
			$css = $css . ' #'.$list->boxname.'nav a { margin: 2px; padding: 2px; text-decoration: none; font-size: 110%; line-height: 1.5em; font-weight: bold; } ';
			if ($list->paginationitemsborder == 1) $css = $css . ' #'.$list->boxname.'nav a { border: 1px solid #ccc; background: '.$list->paginationbarbordercolor.'; } ';
			$css = $css . ' #'.$list->boxname.'nav a:focus { outline: none; } ';
			// Pagination Bar - Active Links
			$css = $css . ' #'.$list->boxname.'nav a.activeSlide { color: #000; background: #ccc; } ';
		endif;
		// Gallery Group
		if ( $list->pagination == 0 && $list->gallery == 1 ) :
			// Gallery Box
			$css = $css . ' #'.$list->boxname.'gallery { width: '.$list->gallerywidth.'; list-style-type: none; display: block; overflow:hidden; margin: 0; padding: 0; '.$list->galleryposition. ' } ';
			// Gallery Items
			$css = $css . ' #'.$list->boxname.'gallery li { position: relative; width: '.$list->gallerythumbnailboxwidth.'; height: '.$list->gallerythumbnailboxheight.'; display: block; overflow:hidden; float:'.$list->gallerydirection.'; margin:'.$list->gallerythumbnailspace.'; }';
			if ($list->gallerythumbnailborder == 1) $css = $css . ' #'.$list->boxname.'gallery li { border-width: '. $list->gallerythumbnailbordersize .'; border-style: solid; border-color: '. $list->gallerythumbnailbordercolor .'; }';
			// Gallery Links
			$css = $css . ' #'.$list->boxname.'gallery a { display: block; }';
			// Gallery Thumbnails
			$css = $css . ' #'.$list->boxname.'gallery a img { width: '.$list->gallerythumbnailwidth.'; height: '.$list->gallerythumbnailheight.'; display: block; overflow:hidden;}';		
			// Gallery Active Links (IE or other browsers)
			if ( preg_match('/MSIE/i', $_SERVER['HTTP_USER_AGENT'] ) ) $css = $css . ' #'.$list->boxname.'gallery a.activeSlide { filter:alpha(opacity=50); }';
			else $css = $css . ' #'.$list->boxname.'gallery a.activeSlide { opacity: 0.5; }';
			$css = $css . ' #'.$list->boxname.'gallery a:focus { outline: none; }';
			// Gallery Images
			$css = $css . ' #'.$list->boxname.'gallery img { border: none; display: block }';
		endif;

		// Apply CSS Styles
		$document =& JFactory::getDocument();
		$document->addStyleDeclaration(trim($css));

		// loading Java scripts (jQuery, Cycle Plugin, and Easing)
		JHTML::script('jquery.js','modules/mod_jt_slideshow/scripts/');
		JHTML::script('jquery.cycle.all.min.js','modules/mod_jt_slideshow/scripts/');
		JHTML::script('jquery.easing.1.3.js','modules/mod_jt_slideshow/scripts/');
		JHTML::script('jquery.easing.compatibility.js','modules/mod_jt_slideshow/scripts/');

		// loading SqueezeBox
		if ( ( $list->linked == 1 && $list->target == "iFrame" ) || $list->linked == 2 ) {
			JHtml::_('behavior.framework');
			JHtml::_('behavior.modal', 'a.modal'); }

		// Notifications, warnings and errors
		if ( $list->boxname == null || $list->boxname == ''  ) JError::raiseWarning('ERROR_CODE', JText::_('MOD_JT_SLIDESHOW_ERROR_BOX_NAME'));
		if ( $list->fx == null || $list->fx == ''  ) JError::raiseWarning('ERROR_CODE', JText::_('MOD_JT_SLIDESHOW_ERROR_FX'));
		if ( $list->pagination == 1 && $list->gallery == 1 ) JError::raiseWarning('ERROR_CODE', JText::_('MOD_JT_SLIDESHOW_ERROR_PAGINATION_AND_GALLERY'));
		if ( $list->image[0] == null || $list->image[0] == '' ) JError::raiseWarning('ERROR_CODE', JText::_('MOD_JT_SLIDESHOW_ERROR_IMAGE'));

		// Return all (required) values
		return $list;		
	}
}