<?php
/**
 * @version		$Id: category_item.php 1492 2012-02-22 17:40:09Z joomlaworks@gmail.com $
 * @package		K2
 * @author		JoomlaWorks http://www.joomlaworks.net
 * @copyright	Copyright (c) 2006 - 2012 JoomlaWorks Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// Define default image size (do not change)
K2HelperUtilities::setDefaultImage($this->item, 'itemlist', $this->params);

?>

<!-- Start K2 Item Layout -->
<div class="catItemView group<?php echo ucfirst($this->item->itemGroup); ?>">
	<div class="catItemHeader">
	  <?php if($this->item->params->get('catItemTitle')): ?>
	  <h3 class="catItemTitle">
			<?php if(isset($this->item->editLink)): ?>
			<!-- Item edit link -->
			<span class="catItemEditLink">
				<a class="modal" rel="{handler:'iframe',size:{x:990,y:550}}" href="<?php echo $this->item->editLink; ?>">
					<?php echo JText::_('K2_EDIT_ITEM'); ?>
				</a>
			</span>
			<?php endif; ?>
	  	<?php if ($this->item->params->get('catItemTitleLinked')): ?>
			<a href="<?php echo $this->item->link; ?>">
	  			<?php echo $this->item->title; ?>
	  		</a>
	  	<?php else: ?>
	  	<?php echo $this->item->title; ?>
	  	<?php endif; ?>
	  </h3>
	  <?php endif; ?>
  </div>
  <div class="catItemBody">
	  <?php if($this->item->params->get('catItemExtraFields') && count($this->item->extra_fields)): ?>
	  <div class="equipeInformation">
	  	<ul>
			<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
			<?php if($extraField->value): ?>
			<li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>">
				<span class="equipeInformationLabel"><?php echo $extraField->name; ?>: </span>
				<span class="equipeInformationValue"><?php echo $extraField->value; ?></span>
			</li>
			<?php endif; ?>
			<?php endforeach; ?>
			</ul>
	  </div>
	  <?php endif; ?>
  </div>
  <div class="clearfix"></div>
  <?php if ($this->item->params->get('catItemReadMore')): ?>
  <!-- Item "read more..." link -->
  <div class="catItemReadMore">
	<a class="k2ReadMore button-round" href="<?php echo $this->item->link; ?>">
		<span><?php echo JText::_('Ver perfil completo'); ?></span>
	</a>
  </div>
  <?php endif; ?>
  <div class="clearfix"></div>
</div>