<?php
/**
 * @copyright	Copyright (C) 2008 - 2011 ZooTemplate.com. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>">
<head>
	<jdoc:include type="head" />
	<?php JHTML::_('behavior.mootools'); ?>
	<?php JHTML::_('behavior.caption', true); ?>
	<?php
		$document = JFactory::getDocument();
		$config =& JFactory::getConfig();
		$document->addStyleSheet('http://fonts.googleapis.com/css?family=Open+Sans:400,700');
		$document->addStyleSheet($ztTools->templateurl() . 'css/system.css');
		$document->addStyleSheet($ztTools->templateurl() . 'css/general.css');
		$document->addStyleSheet($ztTools->templateurl() . 'css/default.css');
		$document->addStyleSheet($ztTools->templateurl() . 'css/template.css');
		$document->addStyleSheet($ztTools->templateurl() . 'css/modules.css');
		$document->addStyleSheet($ztTools->templateurl() . 'css/typo.css');
		$document->addStyleSheet($ztTools->templateurl() . 'css/css3.css');
		$document->addStyleSheet($ztTools->templateurl() . 'css/k2.css');
		$document->addStyleSheet($ztTools->templateurl() . 'css/k2.print.css');
		$document->addStyleSheet($ztTools->templateurl() . 'css/pages.css');
		if($ztrtl == 'rtl') {
			$document->addStyleSheet($ztTools->templateurl() . 'css/template_rtl.css');
			$document->addStyleSheet($ztTools->templateurl() . 'css/typo_rtl.css');
		}
		$document->addScript($ztTools->templateurl() . 'js/jquery.maskedinput.1.3.min.js');
		$document->addScript($ztTools->templateurl() . 'js/script.js');
	?>
	<!--[if lte IE 7]>
	<link rel="stylesheet" href="<?php echo $ztTools->templateurl(); ?>css/ie7.css" type="text/css" />
	<![endif]-->
	<!--[if IE 8]>
	<link rel="stylesheet" href="<?php echo $ztTools->templateurl(); ?>css/ie8.css" type="text/css" />
	<![endif]-->
	<!--[if IE 9]>
	<link rel="stylesheet" href="<?php echo $ztTools->templateurl(); ?>css/ie9.css" type="text/css" />
	<![endif]-->	
	<?php
	include_once (dirname(__FILE__).DS.'header.php');
	
	?>
</head>
<body id="site" class="">
	<div id="wrap-site">
		<!-- BEGIN HEADER -->
		<div id="header">
			<div class="wrapper">
				<div id="header-inner">
					<div id="header-left">
						<div id="logo">
							<div>
								<a href="<?php echo $document->baseurl; ?>" title="<?php echo $ztTools->sitename(); ?>">
									<span><?php echo $ztTools->sitename(); ?></span>
								</a>
							</div>
						</div>
					</div>
					
					<div id="header-right">
						<?php if($this->countModules('share')) : ?>
						<div id="share">
							<jdoc:include type="modules" name="share" />
						</div>
						<?php endif; ?>
						
						<?php if($this->countModules('header-phone')) : ?>
						<div id="header-phone">
							<jdoc:include type="modules" name="header-phone" />
						</div>
						<?php endif; ?>
						
						<?php if($this->countModules('header-search')) : ?>
						<div id="header-search">
							<jdoc:include type="modules" name="header-search" />
						</div>
						<?php endif; ?>
					</div>
					<div class="clearfix"></div>
					<?php if($this->countModules('main-menu')) : ?>
					<div id="main-menu">
						<div id="main-menu-inner">
							<jdoc:include type="modules" name="main-menu" />
							<div class="clearfix"></div>
						</div>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<!-- END HEADER -->
		
		<?php if($this->countModules('slideshow')) : ?>
		<!-- BEGIN SLIDESHOW -->
		<div id="slideshow">
			<div class="wrapper">
				<div id="slideshow-inner">
					<jdoc:include type="modules" name="slideshow" />
				</div>
			</div>
		</div>
		<!-- END SLIDESHOW -->
		<?php endif; ?>
		
		<!-- BEGIN CONTENT -->
		<div id="content">
			<div class="wrapper">
				<div id="content-inner">
					
					<?php if($this->countModules('local-atendimento') || $this->countModules('agendar-sua-consulta')) : ?>
					<div class="content">
						<?php if($this->countModules('local-atendimento')) : ?>
						<div class="content-left">
							<?php if($this->countModules('local-atendimento')) : ?>
							<div id="local-atendimento" class="border-round">
								<jdoc:include type="modules" name="local-atendimento" style="xhtmlhospitalcontent" />
							</div>
							<?php endif; ?>
						</div>
						<?php endif; ?>
						<?php if($this->countModules('agendar-sua-consulta')) : ?>
						<div class="content-right">
							<?php if($this->countModules('agendar-sua-consulta')) : ?>
							<div id="agendar-sua-consulta" class="border-round">
								<jdoc:include type="modules" name="agendar-sua-consulta" style="xhtmlhospitalcontent" />
							</div>
							<?php endif; ?>
						</div>
						<?php endif; ?>
						<div class="clearfix"></div>
					</div>
					<?php endif; ?>
					
					<?php //if($this->countModules('nossos-servicos')) : ?>
					<div class="content border-round">
						
						<div id="main-content">
							<jdoc:include type="message" />
							
							<?php if($this->countModules('breadcrumbs')) : ?>
							<div id="breadcrumbs">
								<jdoc:include type="modules" name="breadcrumbs" />
							</div>
							<?php endif; ?>
							
							<?php if($this->countModules('contact-info')) : ?>
							<div id="contact-info">
								<jdoc:include type="modules" name="contact-info" />
							</div>
							<?php endif; ?>
							
							<jdoc:include type="component" />
							<div class="clearfix"></div>
						</div>
						
						<?php if($this->countModules('nossos-servicos')) : ?>
						<div id="nossos-servicos" class="">
							<jdoc:include type="modules" name="nossos-servicos" style="xhtmlhospitalcontent" />
						</div>
						<?php endif; ?>
						<div class="clearfix"></div>
					</div>
					<?php //endif; ?>
					
					<?php if($this->countModules('convenios-atendidos') || $this->countModules('artigos')) : ?>
					<div class="content">
						<?php if($this->countModules('convenios-atendidos')) : ?>
						<div class="content-left">
							<?php if($this->countModules('convenios-atendidos')) : ?>
							<div id="convenios-atendidos" class="border-round">
								<jdoc:include type="modules" name="convenios-atendidos" style="xhtmlhospitalcontent" />
							</div>
							<?php endif; ?>
						</div>
						<?php endif; ?>
						<?php if($this->countModules('artigos') || $this->countModules('artigos2') || $this->countModules('links')) : ?>
						<div class="content-right">
							<?php if($this->countModules('artigos') || $this->countModules('artigos2') || $this->countModules('links')) : ?>
							<div id="artigos" class="border-round">
								<?php if($this->countModules('artigos')) : ?>
									<jdoc:include type="modules" name="artigos" style="xhtmlhospitalcontent" />
								<?php endif; ?>
								
								<?php if($this->countModules('artigos2')) : ?>
								<div id="artigos2">
									<jdoc:include type="modules" name="artigos2" style="xhtmlhospitalcontent" />
								</div>
								<?php endif; ?>
								
								<?php if($this->countModules('links')) : ?>
								<div id="links">
									<jdoc:include type="modules" name="links" style="xhtmlhospitalcontent" />
								</div>
								<div class="clearfix"></div>
								<?php endif; ?>
							</div>
							<?php endif; ?>
						</div>
						<?php endif; ?>
						<div class="clearfix"></div>
					</div>
					<?php endif; ?>
					
					<?php if($this->countModules('enciclopedia-oftalmologia')) : ?>
					<div class="content border-round">
						<?php if($this->countModules('enciclopedia-oftalmologia')) : ?>
						<div id="enciclopedia-oftalmologia" class="">
							<jdoc:include type="modules" name="enciclopedia-oftalmologia" style="xhtmlhospitalcontent" />
						</div>
						<?php endif; ?>
						<div class="clearfix"></div>
					</div>
					<?php endif; ?>
					
					<div class="clearfix"></div>
				</div>
			</div>
		</div>
		<!-- END CONTENT -->
		
		<!-- BEGIN FOOTER -->
		<div id="footer">
		    <div id="footer-abstract">
			<div class="wrapper">
				<div id="footer-inner">
					<div id="footer-left">
						<?php if($this->countModules('address')) : ?>
						<div id="address">
							<jdoc:include type="modules" name="address" style="xhtmlhospitalfooter" />
						</div>
						<?php endif; ?>
					</div>
					<div id="footer-right">
						<?php if($this->countModules('copyright')) : ?>
						<div id="copyright">
							<jdoc:include type="modules" name="copyright" />
						</div>
						<?php endif; ?>
					</div>
					<div class="clearfix"></div>
				</div>
			</div>
		    </div>
		</div>
		<!-- END FOOTER -->
	</div>
	<jdoc:include type="modules" name="debug" />
</body>
</html>