<?php
/**
* @version		$Id: default.php 1499 2012-02-28 10:28:38Z lefteris.kavadas $
* @package		K2
* @author		JoomlaWorks http://www.joomlaworks.net
* @copyright	Copyright (c) 2006 - 2012 JoomlaWorks Ltd. All rights reserved.
* @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');
$document = JFactory::getDocument();
$document->addScript('modules/mod_k2_content/assets/js/jquery.carrossel.js');
?>
<div id="k2ModuleBox<?php echo $module->id; ?>" class="convenios k2ItemsBlock<?php if($params->get('moduleclass_sfx')) echo ' '.$params->get('moduleclass_sfx'); ?>">
	<div class="convenios-container">
		<?php if(count($items)): ?>
		<ul>
			<?php foreach ($items as $key=>$item):	?>
			<li>
				<?php if($params->get('itemTitle')): ?>
				<a class="moduleItemTitle" href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a>
				<?php endif; ?>
				<?php if($params->get('itemImage') || $params->get('itemIntroText')): ?>
				<?php if($params->get('itemImage') && isset($item->image)): ?>
				
				<?php 
				if($params->get('itemExtraFields') && count($item->extra_fields)) :
					$extraField	= $item->extra_fields;
					$link		= trim($extraField[0]->value);
				endif;
				?>
				
				<a class="moduleItemImage" href="<?php echo ($link == '' ? '#' : $link); ?>" target="_blank" title="<?php echo K2HelperUtilities::cleanHtml($item->title); ?>">
					<img src="parts/thumb.php?src=<?php echo $item->image; ?>&amp;w=120&amp;h=100&amp;q=100&amp;a=100" alt="<?php echo K2HelperUtilities::cleanHtml($item->title); ?>"/>
				</a>
				<?php endif; ?>
				<?php if($params->get('itemIntroText')): ?>
				<?php echo $item->introtext; ?>
				<?php endif; ?>
				<?php endif; ?>
				<?php if($params->get('itemReadMore') && $item->fulltext): ?>
				<a class="moduleItemReadMore" href="<?php echo $item->link; ?>">
					<?php echo JText::_('K2_READ_MORE'); ?>
				</a>
				<?php endif; ?>
			</li>
			<?php endforeach; ?>
		</ul>
		<div class="clearfix"></div>
		<?php endif; ?>
	</div>
</div>