<?php
/**
 * @version		$Id: k2.php 1354 2011-11-25 17:10:28Z joomlaworks $
 * @package		K2
 * @author		JoomlaWorks http://www.joomlaworks.gr
 * @copyright	Copyright (c) 2006 - 2011 JoomlaWorks Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');
jimport('joomla.html.parameter');
jimport('joomla.version');

class plgSystemK2MultiImages extends JPlugin {

	function plgSystemK2MultiImages(&$subject, $config) {

		parent::__construct($subject, $config);
	}
	
	function onAfterRoute() {
	
		$version = new JVersion;
		$joomlaVersion = $version->RELEASE;		
		
		if($joomlaVersion < 1.6) {
			$pluginPath = JPATH_SITE.DS.'plugins'.DS.'system'.DS.'K2MultiImages';
			$pluginPathSite = JURI::root().'plugins/system/K2MultiImages';
		}
		else {
			$pluginPath = JPATH_SITE.DS.'plugins'.DS.'system'.DS.'k2multiimages'.DS.'K2MultiImages';
			$pluginPathSite = JURI::root().'plugins/system/k2multiimages/K2MultiImages';
		}	
		
			//compatibility with K2Multirating
			if(JPluginHelper::isEnabled('system', 'k2multirate')) {
				$plgMultirate = JPluginHelper::getPlugin('system', 'k2multirate');
				$plgMultirateParams = new JParameter($plgMultirate->params);
				
				if($plgMultirateParams->get("catfilter", 0) == 1) {
					$selected = $plgMultirateParams->get("category_id", 1);
					
					if(is_array($selected))
						$selected = implode("|", $selected);
					
					$catids = explode("|", $selected);
					
					@require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'models'.DS.'itemlist.php');
					$model = new K2ModelItemlist;
					
					foreach($catids as $catid) {
						if($plgMultirateParams->get("getChildren", 1)) {
							$childs = K2ModelItemlist::getCategoryTree($catid);
							foreach($childs as $child) {
								$results[] = $child;
							}
						}
						$results[] = $catid;
					}
					
					$itemID = JRequest::getInt("id");
					$catid = $this->getCatid($itemID);
					
					if(in_array($catid, $results)) {
						$multirating = 1;
					}
					else {
						$multirating = 0;
					}
				}
				else {
					$multirating = 1;
				}
			}
			else {
				$multirating = 0;
			}
	
		$mainframe = &JFactory::getApplication();
		
		if(JRequest::getVar("option") == "com_k2" && JRequest::getVar("view") == "item") {
			
			//save and edit item
			$task = JRequest::getVar("task");
			if($task == "save" || $task == "apply") {
				error_reporting(E_ALL ^ E_NOTICE);
						
				if (!defined('JPATH_ROOT')) {
				   define('JPATH_ROOT', JPath::clean(JPATH_SITE));
				}
						
				if (!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
				if (!defined('JPATH_COMPONENT')) define( 'JPATH_COMPONENT',	JPATH_BASE.DS.'components'.DS.'com_k2');
				if (!defined('JPATH_COMPONENT_SITE')) define( 'JPATH_COMPONENT_SITE', JPATH_SITE.DS.'components'.DS.'com_k2');
				if (!defined('JPATH_COMPONENT_ADMINISTRATOR')) define( 'JPATH_COMPONENT_ADMINISTRATOR',	JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2');
			
				JRequest::checkToken() or jexit('Invalid Token');

				require_once ($pluginPath.DS.'administrator'.DS.'models'.DS.'itemmultiimages.php');
				$model = new K2ModelItemMultiImages;	
				
				if(!$mainframe->isAdmin()) {
					$model->save(true);	
				}
				else {
					$model->save();
				}
				
				return;
			}	
			
			//backend view
			if ($mainframe->isAdmin()) { 
		
				error_reporting(E_ALL ^ E_NOTICE);
						
				if (!defined('JPATH_ROOT')) {
				   define('JPATH_ROOT', JPath::clean(JPATH_SITE));
				}
						
				if (!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
				if (!defined('JPATH_COMPONENT')) define( 'JPATH_COMPONENT',	JPATH_BASE.DS.'components'.DS.'com_k2');
				if (!defined('JPATH_COMPONENT_SITE')) define( 'JPATH_COMPONENT_SITE', JPATH_SITE.DS.'components'.DS.'com_k2');
				if (!defined('JPATH_COMPONENT_ADMINISTRATOR')) define( 'JPATH_COMPONENT_ADMINISTRATOR',	JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2');

				//replacing standart view
				require_once (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'controllers'.DS.'item.php');
				$controller = new K2ControllerItem;
				
				$config['name'] =  "item";
				$config['default_task'] =  "display";
				$config['base_path'] =  $pluginPath.DS."administrator";
				$config['model_path'] = $pluginPath.DS."administrator".DS."models";
				$config['view_path'] =  $pluginPath.DS."administrator".DS."views";		
				
				$controller->__construct($config);
				
				$view = &$controller->getView("item", "html");
				
				$view->addTemplatePath($pluginPath.DS."administrator".DS.'templates');
				$controller->addModelPath($pluginPath.DS."administrator".DS."models");
				
			}
			
			//site item view			
			else if(JRequest::getVar("task") != "add" && JRequest::getVar("task") != "edit" && $multirating != 1) {

				error_reporting(E_ALL ^ E_NOTICE);
						
				if (!defined('JPATH_ROOT')) {
				   define('JPATH_ROOT', JPath::clean(JPATH_SITE));
				}
						
				if (!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
				if (!defined('JPATH_COMPONENT')) define( 'JPATH_COMPONENT',	JPATH_BASE.DS.'components'.DS.'com_k2');
				if (!defined('JPATH_COMPONENT_SITE')) define( 'JPATH_COMPONENT_SITE', JPATH_SITE.DS.'components'.DS.'com_k2');
				if (!defined('JPATH_COMPONENT_ADMINISTRATOR')) define( 'JPATH_COMPONENT_ADMINISTRATOR',	JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2');

				//replacing standart view
				require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'controllers'.DS.'item.php');
				$controller = new K2ControllerItem;
				
				$config['name'] =  "item";
				$config['default_task'] =  "display";
				$config['base_path'] =  $pluginPath;
				$config['model_path'] = $pluginPath.DS."models";
				$config['view_path'] =  $pluginPath.DS."views";		
				
				$controller->__construct($config);

				$view = &$controller->getView("item", "html");				
				$view->addTemplatePath($pluginPath.DS.'templates');
				
				$document = &JFactory::getDocument();
				$document->addScript($pluginPathSite.'/assets/highslide/highslide-full.js');
				$document->addStyleSheet($pluginPathSite.'/assets/highslide/highslide.css');
				
				$document->addScriptDeclaration("
				
					if (typeof jQuery == 'undefined') {
						document.write('<scr'+'ipt type=\"text/javascript\" src=\"".$pluginPathSite."/assets/jquery-1.7.1.min.js\"></scr'+'ipt>');
						document.write('<scr'+'ipt>jQuery.noConflict();</scr'+'ipt>');
					}
				
					hs.graphicsDir = '".$pluginPathSite."/assets/highslide/graphics/';
					hs.captionEval = 'this.a.title'

					var galleryOptions = {

						slideshowGroup: 'gallery',
						wrapperClassName: 'dark',
						dimmingOpacity: 0.8,
						align: 'center',
						transitions: ['expand', 'crossfade'],
						fadeInOut: true,
						wrapperClassName: 'borderless floating-caption',
						marginLeft: 100,
						marginBottom: 80,
						numberPosition: 'caption'

					};
					
					// Add the slideshow controller
					hs.addSlideshow({
						slideshowGroup: 'gallery',
						interval: 5000,
						repeat: false,
						useControls: true,
						fixedControls: 'fit',
						overlayOptions: {
							className: 'text-controls',
							opacity: 0.75,
							position: 'bottom center',
							offsetX: 0,
							offsetY: -15,
							hideOnMouseOut: true
						}
					});
					");

			}
			
			//add new item or edit from frontend
			if(JRequest::getVar("task") == "add" || JRequest::getVar("task") == "edit") {
			
				error_reporting(E_ALL ^ E_NOTICE);
						
				if (!defined('JPATH_ROOT')) {
				   define('JPATH_ROOT', JPath::clean(JPATH_SITE));
				}
						
				if (!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
				if (!defined('JPATH_COMPONENT')) define( 'JPATH_COMPONENT',	JPATH_BASE.DS.'components'.DS.'com_k2');
				if (!defined('JPATH_COMPONENT_SITE')) define( 'JPATH_COMPONENT_SITE', JPATH_SITE.DS.'components'.DS.'com_k2');
				if (!defined('JPATH_COMPONENT_ADMINISTRATOR')) define( 'JPATH_COMPONENT_ADMINISTRATOR',	JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2');
			
				//replacing standart view
				require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'controllers'.DS.'item.php');
				$controller = new K2ControllerItem;
				
				$config['name'] =  "item";
				$config['default_task'] =  "display";
				$config['base_path'] =  $pluginPath.DS."administrator";
				$config['model_path'] = $pluginPath.DS."administrator".DS."models";
				$config['view_path'] =  $pluginPath.DS."administrator".DS."views";		
				
				$controller->__construct($config);
				
				$view = &$controller->getView("item", "html");
				
				$view->addTemplatePath($pluginPath.DS."administrator".DS.'templates');
				$controller->addModelPath($pluginPath.DS."administrator".DS."models");
								
			}		
			
		}
		
	}
	
	function getCatid($itemid) {
		$db = & JFactory::getDBO();
		$query = "SELECT catid FROM #__k2_items WHERE id = {$itemid}";
		$db->setQuery($query);
		return $db->loadResult();
	}
	
}