jQuery(document).ready(function($){
	function removePX(value) {
		value	= value.substring(0, value.length - 2);
		value	= parseFloat(value);
		return value;
	}; 
	$.jqueryCarrossel	= {
		init		: function(seletor, options) {
			var $this		= this;
			$this.settings		= {
				viewImage	: 2,
				scrollImage	: 2,
				speedAnimate	: 500,
				classButtonPrev : 'prevButton',
				classButtonNext : 'nextButton'
			};
			
			$this.htmlButtonPrev	= "<a href='#' class='" + $this.settings.classButtonPrev + "'></a>";
			$this.htmlButtonNext	= "<a href='#' class='" + $this.settings.classButtonNext + "'></a>";
			
			$this.container		= $(seletor);
			$this.buttonPrev	= $('.' + $this.settings.classButtonPrev);
			$this.buttonNext	= $('.' + $this.settings.classButtonNext);
			$this.topButtons	= $this.container.parent().height();
			$this.container.ul	= $this.container.find('ul');
			$this.container.li	= $this.container.find('li');
			$this.container.li.count= $this.container.li.length;
			$this.container.li.width= $this.container.li.width() + (removePX($this.container.li.css('paddingLeft'))) + (removePX($this.container.li.css('paddingRight'))) + (removePX($this.container.li.css('marginLeft'))) + (removePX($this.container.li.css('marginRight')));
			
			$this.i			= $this.settings.viewImage;
			
			//insert buttons next, prev
			$this.insert.buttonPrev($this);
			$this.insert.buttonNext($this);
			
			//define container width
			$this.config.sizeContainer($this);
			
			//init events of buttons
			$this.initEvents.clickPrevButton($this);
			$this.initEvents.clickNextButton($this);
			
		},
		insert		: {
			buttonPrev	: function(seletor) {
				seletor.container.before(seletor.htmlButtonPrev);
			},
			buttonNext	: function(seletor) {
				seletor.container.after(seletor.htmlButtonNext);
			}
		},
		config		: {
			sizeContainer	: function(seletor) {
				seletor.container.css('width', seletor.settings.viewImage * seletor.container.li.width);
			}
		},
		initEvents	: {
			clickPrevButton	: function(seletor) {
				seletor.buttonPrev.live('click', function() {
					console.log('Prev');
					if(seletor.i > seletor.settings.viewImage) {
						seletor.container.ul.animate({
							'left'	: '+=' + seletor.container.li.width * seletor.settings.scrollImage
						}, seletor.settings.speedAnimate);
						seletor.i	= seletor.i - seletor.settings.scrollImage;
					}
					return false;
				});
			},
			clickNextButton	: function(seletor) {
				seletor.buttonNext.live('click', function() {
					console.log('Next');
					if(seletor.i < seletor.container.li.count) {
						seletor.container.ul.animate({
							'left'	: '-=' + seletor.container.li.width * seletor.settings.scrollImage
						}, seletor.settings.speedAnimate);
						seletor.i	= seletor.i + seletor.settings.scrollImage;
					}
					return false;
				});
			}
		}
	};
	
	$.jqueryCarrossel.init('.convenios-container');
	
});