<?php
/**
* @package ccNewsletter
* @version 1.0.9
* @author  Chill Creations <info@chillcreations.com>
* @link    http://www.chillcreations.com
* @copyright Copyright (C) 2008 - 2010 Chill Creations-All rights reserved
* @license GNU/GPL, see LICENSE.php for full license.
* See COPYRIGHT.php for more copyright notices and details.

This file is part of ccNewsletter.
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
**/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');
jimport( 'joomla.application.component.view' );
/**
 * Hellos View
 *
 * @package    Joomla.Tutorials
 * @subpackage Components
 */
class ccNewsletterViewnewsletters extends JView
{
	/**
	 * ccNewsletters display function
	 * @return void
	 **/
	function display($tpl = null)
	{
		$db =& JFactory::getDBO();
		$cid = JRequest::getVar( 'cid', array(0), '', 'array' );
		JToolBarHelper::title(   JText::_( 'CC_NEWSLETTER_TITLE' ) . ' - ' . JText::_( 'Newsletters' ), 'ccnewsletter.png' );
		JToolBarHelper::addNewX();
		JToolBarHelper::editListX();
		JToolBarHelper::customX( 'copy', 'copy.png', 'copy_f2.png', 'Copy', true );
		JToolBarHelper::deleteList(JText::_( 'CC_WARN_DELETE_NEWSLETTERS' ));
		JToolBarHelper::divider();
		JToolBarHelper::custom('ccsend', 'send', '', JText::_( 'CC_TOOL_SEND_NEWSLETTER'), false);
		JToolBarHelper::custom('ccsendtesting', 'forward', '', JText::_( 'CC_TOOL_TEST_MESSAGE'), false);
		JToolBarHelper::divider();

		$filter					= JRequest::getVar('newsletter_filter');
		$sortColumn		= JRequest::getVar('filter_order','ordering');
		$sortOrder		= JRequest::getVar('filter_order_Dir','asc');
		$rows		= $this->get('data');
		$pagination		= $this->get('pagination');

//joomla 1.6
		if($this->versionCompare()!="1.5")
		{
			$msg=JRequest::getVar('msg','0');
			//configuration
			$query ="SELECT * FROM #__ccnewsletter_configuration WHERE id=1";
			$db->setQuery( $query );
			$configurationrow     = $db->loadObject();
			if($msg=="body")
			{
				$msg = JText::_( 'CC_MSG_BODY_EMPTY' );
				JFactory::getApplication()->enqueueMessage( $msg, 'error' );
			}
			elseif($msg=="fromname")
			{
				$msg = JText::_( 'CC_MSG_FROMNAME_EMPTY' );
				JFactory::getApplication()->enqueueMessage( $msg, 'error' );
			}
			elseif($msg=="fromemail")
			{
				$msg = JText::_( 'CC_MSG_FROMEMAIL_EMPTY');
				JFactory::getApplication()->enqueueMessage( $msg, 'error' );
			}
			elseif($msg=="testemail")
			{
				$msg = JText::_( "The test email address is empty! Send Message routine aborted.");
				JFactory::getApplication()->enqueueMessage( $msg, 'error' );
			}
			elseif($msg=="subject")
			{
				$msg = JText::_( 'CC_MSG_TESTEMAIL_EMPTY' );
				JFactory::getApplication()->enqueueMessage( $msg, 'error' );
			}
			elseif($msg=="testmailsent")
			{
				$testEmailAddress = $configurationrow->testemail;
				$msg = JText::_( 'CC_MSG_TESTMAIL_SENT' ) .'&nbsp;'. $testEmailAddress;
				JFactory::getApplication()->enqueueMessage( $msg );
			}
		}

 		global $mainframe;
 		$this->_addCss();

		$sql = "SELECT 	date_format FROM #__ccnewsletter_configuration WHERE id=1 ";
		$db->setQuery($sql);
		$date_format = $db->loadResult();

		$pageNav =$pagination;

		$javascript		= 'onchange="document.adminForm.submit();"';
		$lists['order_Dir']	= $sortOrder;
		$lists['order']		= $sortColumn;
		$lists['search']= $filter;


		$query = "SELECT * FROM #__ccnewsletter_newsletters LIMIT 1";
		$db->setQuery( $query);
		$latestNewsletter = $db->loadObject();

		//$newsletterModel =& $this->getModel();
		//$newsletterModel = & $this->getModel('newsletter');
		$newsletterModel =& $this->getModel();
		//echo "Newskletetr".$newsletterModel;

		$newsletterForPreviewBody=$newsletterModel->convertImgTags($latestNewsletter->body);
		// call the backgroiund image convert function of our model and overwrite the background property of tables
		$newsletterForPreviewBody=$newsletterModel->convertBackgroundTags($newsletterForPreviewBody);
		// call the internal link convert function of our model and overwrite the internal link property of tables
		$newsletterForPreviewBody=$newsletterModel->convertInternalLink($newsletterForPreviewBody);

		/* Get the component base directory */
		$adminDir = JPATH_ADMINISTRATOR .DS. 'components';
		$siteDir = JPATH_SITE .DS. 'components';
		$file = $adminDir.DS.'com_ccnewsletter'.DS.'install.xml';
		$xml = JFactory::getXMLParser('Simple');
		$xml->loadFile($file);
		$xml = $xml->document;
		$c_version = $xml->version[0]->data();
		$c_name = $xml->name[0]->data();



		/* Check for New Version */
		$myReadAccess= new versionRead('http://www.chillcreations.com/versionnumbers.txt');
		if($data = $myReadAccess->getFileContents()) {
			$pieces = explode("\n", $data);
			foreach($pieces as $piece)
			{
				$small_pieces[] = explode(",", $piece);
			}
			$versionContent = "";
 			foreach( $small_pieces as $small_piece)
			{
  				if ($small_piece[0] == $c_name && $small_piece[1] > $c_version && trim($small_piece[3]) != 'none') {
					$versionContent ="<div style='font-weight:bold;text-align:center;color:#FF0000;'><a style='color:#FF0000;' href='".$small_piece[2]."' target='_blank'>". JText::_( 'ID_WARNING' ) . " " .JText::_( 'ID_NEW_VERSION' ) . " " . $small_piece[1]. " " .JText::_( 'ID_AVAIALBLE_DOWNLOAD' ) ."</a>";
					$versionContent .="<br/>".$small_piece[3]."</div>";
  				}
				else if ($small_piece[0] == $c_name && $small_piece[1] > $c_version && trim($small_piece[3]) == 'none') {
					$versionContent = "<div style='font-weight:bold;text-align:center;color:#FF0000;'><a style='color:#FF0000;' href='".$small_piece[2]."' target='_blank'>". JText::_( 'ID_WARNING' ) . " " .JText::_( 'ID_NEW_VERSION' ) . " " . $small_piece[1]. " " .JText::_( 'ID_AVAIALBLE_DOWNLOAD' ) ."</a></div>";
				}
			}
		}
		if(isset($versionContent) && $versionContent != "") {
			$this->assignRef('versionContent',	$versionContent);
		}

		$query ="SELECT * FROM #__ccnewsletter_configuration WHERE id=1";
		$db->setQuery( $query );
		$configurationrow     = $db->loadObject();

		$testEmail = $configurationrow->testemail;
		$emailbatch = $configurationrow->emailbatch;
		$batchinter = $configurationrow->batchinter;
		$scripttimeout = $configurationrow->scripttimeout;

		$this->assignRef('version',		$c_version);
		$this->assignRef('name',		$c_name);
		$javascript		= 'onchange="document.adminForm.submit();"';
		$lists['order_Dir']	= $sortOrder;
		$lists['order']		= $sortColumn;
		$lists['search']= $filter;

		$this->assignRef('items',		$rows);
		$this->assignRef('pageNav',		$pageNav);
		$this->assignRef('lists',		$lists);
		$this->assignRef('latestNewsletter',$latestNewsletter);
		$this->assignRef('newsletterForPreviewBody',$newsletterForPreviewBody);
		$this->assignRef('date_format',$date_format);
		$this->assignRef('emailbatch',$emailbatch);
		$this->assignRef('batchinter',$batchinter);
		$this->assignRef('scripttimeout',$scripttimeout);
		$this->assignRef('testEmail',$testEmail);
		parent::display($tpl);
	}
	function _addCss()
	{
	    $document =& JFactory::getDocument();
	    $document->addStyleSheet('components/com_ccnewsletter/assets/ccnewsleter.css');
	}
	function versionCompare()
	{
		$jversion = new JVersion();
		$current_version =  $jversion->getShortVersion();
		return substr($current_version,0,3);
	}

}
