<?php
/**
* @package ccNewsletter
* @version 1.0.9
* @author  Chill Creations <info@chillcreations.com>
* @link    http://www.chillcreations.com
* @copyright Copyright (C) 2008 - 2010 Chill Creations-All rights reserved
* @license GNU/GPL, see LICENSE.php for full license.
* See COPYRIGHT.php for more copyright notices and details.

This file is part of ccNewsletter.
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
**/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');
class ccNewsletterModelsubscribers extends JModel
{
	/**
	 * Constructor that retrieves the ID from the request
	 *
	 * @access	public
	 * @return	void
	 */
	var $_query;
	var $_data;
	var $_total=null;
	var $_pagination=null;
	/**
	 * Constructor that retrieves the ID from the request
	 *
	 * @access	public
	 * @return	void
	 */
	function _buildQuery()
	{
		$mainframe =& JFactory::getApplication();
		$db =& JFactory::getDBO();

		$filter				= JRequest::getVar('newsletter_filter');
		$sortColumn		= $mainframe->getUserStateFromRequest('com_ccinvoices.subscribers.sortColumn','filter_order','ordering');
		$sortOrder		= $mainframe->getUserStateFromRequest('com_ccnewsletter.subscribers.sortOrder','filter_order_Dir','asc');
		$mainframe->setUserState('com_ccnewsletter.subscribers.sortColumn',$sortColumn);
		$mainframe->setUserState('com_ccnewsletter.subscribers.sortOrder',$sortOrder);
		$search=$filter;
		$where = "";


		$viewstatus=JRequest::getVar("status","select");

		if($viewstatus!="select")
		{
			$where.= "s.enabled=".$viewstatus." AND ";
		}
		$where.= ' (LOWER(s.name) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false ) . ' OR LOWER(s.email) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false ).')';
		$this->_query="SELECT s.* FROM #__ccnewsletter_subscribers AS s " .
				"WHERE $where ORDER BY $sortColumn $sortOrder";
	}
	function versionCompare()
	{
		$jversion = new JVersion();
		$current_version =  $jversion->getShortVersion();
		return (version_compare('1.6.0', $current_version) <= 0);
	}
	function __construct()
	{
		parent::__construct();

		$this->_buildQuery();
		$mainframe =& JFactory::getApplication();

		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('com_ccnewsletter.subscribers.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = $mainframe->getUserStateFromRequest('com_ccnewsletter.subscribers.limitstart', 'limitstart', 0, 'int');

		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('com_ccnewsletter.subscribers.limit', $limit);
		$this->setState('com_ccnewsletter.subscribers.limitstart', $limitstart);
	}
	function getData()
	{
		if (empty($this->_data))
			$this->_data=$this->_getList($this->_query,$this->getState('com_ccnewsletter.subscribers.limitstart'), $this->getState('com_ccnewsletter.subscribers.limit'));
		return $this->_data;
	}

	function getTotal()
	{
		if (empty($this->_total))
			$this->_total = $this->_getListCount($this->_query);
		return $this->_total;
	}

	function getPagination()
	{
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination($this->getTotal(), $this->getState('com_ccnewsletter.subscribers.limitstart'), $this->getState('com_ccnewsletter.subscribers.limit'));
		}
		return $this->_pagination;
	}
	function getInvoices()
	{
		$cid = JRequest::getVar('cid');
		if(is_array($cid)) $cid = intval($cid[0]);
		$row= & JTable::getInstance('invoices','Table');
		$row->load($cid);
		return $row;
	}

    function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}
	function store()
	{
		$row =& $this->getTable();
		$post	= JRequest::get( 'post' );
		if (!$row->bind($post))
		 {
			//$this->setError($this->_db->getErrorMsg());
			return false;
		 }
		if(!$row->id)
		{
			$db =& JFactory::getDBO();
			$query = "SELECT * FROM #__ccnewsletter_subscribers WHERE email=".$db->Quote($row->email)."";
			$db->setQuery( $query );
			$rows = $db->loadObjectList();
			$totals = count($rows);
			if($totals=='0')
			{
				if(!$row->id)
				{
					$row->set('sdate', date('Y-m-d H:i:s', time()));
				}
				// Make sure data is valid
				if (!$row->check())
				{
					return false;
				}
				// Store it
				if (!$row->store())
				{
					return false;
				}
				return true;
			}
		}
		else
		{
				$db =& JFactory::getDBO();
       			$query = "SELECT * FROM #__ccnewsletter_subscribers WHERE id=".$row->id;
				$db->setQuery( $query );
				$rows = $db->loadObject();
				if($rows->email == $row->email)
				{
					if (!$row->check())
					{
						return false;
					}
					if (!$row->store())
					{
						return false;
					}

					return true;
				}
				else
				{
						$query = "SELECT * FROM #__ccnewsletter_subscribers WHERE email=".$db->Quote($row->email)."";
						$db->setQuery( $query );
						$rows = $db->loadObjectList();
						$totals = count($rows);
					    if($totals=='0')
						{
							if(!$row->id)
							{
								$row->set('sdate', date('Y-m-d H:i:s', time()));
							}
							// Make sure data is valid
							if (!$row->check())
							{
								return false;
							}
							// Store it
							if (!$row->store())
							{
								return false;
							}
							return true;
						}
						else
						{
							return false;
						}

		        }
       }
	}
	function delete()
	{
		$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );
		$row =& $this->getTable();
		if (count( $cids ))
		{
			foreach($cids as $cid)
			{
				if (!$row->delete( $cid ))
				{
					return false;
				}
			}
		}
		return true;
	}

	function synchronization()
	{
		$db =& JFactory::getDBO();
		$params = &JComponentHelper::getParams( 'com_ccnewsletter' );

		//configuration
		$query ="SELECT * FROM #__ccnewsletter_configuration WHERE id=1";
		$db->setQuery( $query );
		$configurationrow     = $db->loadObject();
		$syncallusers = $configurationrow->syncalluser;
		if($syncallusers)
		{
			$query = "INSERT INTO #__ccnewsletter_subscribers (name, email, enabled, sdate)"
					. "	SELECT name, email, '1', registerDate FROM #__users WHERE (email) NOT IN "
					. " (SELECT email FROM #__ccnewsletter_subscribers)"
				;
		}
		else
		{
			$query = "INSERT INTO #__ccnewsletter_subscribers (name, email, enabled, sdate)"
					. "	SELECT name, email, '1', registerDate FROM #__users WHERE (email) NOT IN "
					. " (SELECT email FROM #__ccnewsletter_subscribers) AND block=0"
				;
		}
		$db->setQuery( $query );
		$db->query();
		$num_rows = $db->getAffectedRows();
		return $num_rows;
	}
	function susynchronization()
	{
		$db =& JFactory::getDBO();
		include_once(JPATH_SITE.DS."administrator".DS."components".DS."com_virtuemart".DS."virtuemart.cfg.php");
		$vmtable_prfix = VM_TABLEPREFIX;
		$query = "INSERT INTO #__ccnewsletter_subscribers (email, name, enabled, sdate)"
				. "\n (SELECT u.user_email , CONCAT(u.first_name, u.last_name) AS username ,  '1', FROM_UNIXTIME(o.cdate) "
				. "\n FROM #__".$vmtable_prfix."_order_user_info AS u"
				. "\n LEFT JOIN  #__".$vmtable_prfix."_orders AS o ON u.order_id = o.order_id"
				. "\n WHERE (u.user_email) NOT IN  (SELECT s.email FROM #__ccnewsletter_subscribers AS s)"
				. "\n  GROUP BY u.user_email )"
				;
		$db->setQuery( $query );
		if (!$db->query()) {
			return JError::raiseWarning( 500, $db->getErrorMsg() );
		}
		$num_rows = $db->getAffectedRows();
		return $num_rows;
	}
}
?>
